<?php
require_once __DIR__ . '/wp-load.php';

echo "<h2>Debug: User vs Employee Check</h2>";

// 1. Get all WP Users
$users = get_users();
echo "<h3>WordPress Users (" . count($users) . ")</h3>";
echo "<table border='1' cellspacing='0' cellpadding='5'>";
echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Roles</th></tr>";
$user_map = [];
foreach ($users as $user) {
    $user_map[$user->ID] = $user->user_login;
    echo "<tr>";
    echo "<td>{$user->ID}</td>";
    echo "<td>{$user->user_login}</td>";
    echo "<td>{$user->user_email}</td>";
    echo "<td>" . implode(', ', $user->roles) . "</td>";
    echo "</tr>";
}
echo "</table>";

// 2. Get Employee Posts
$args = [
    'post_type' => 'hrm_employee',
    'posts_per_page' => -1,
    'post_status' => 'any'
];
$employees = get_posts($args);

echo "<h3>Employee Posts (" . count($employees) . ")</h3>";
echo "<table border='1' cellspacing='0' cellpadding='5'>";
echo "<tr><th>ID</th><th>Title (Name)</th><th>Linked User ID</th><th>Status</th></tr>";
$employee_user_ids = [];
foreach ($employees as $emp) {
    $linked_user = $emp->post_author; // We store user_id in post_author based on code
    $employee_user_ids[] = $linked_user;
    echo "<tr>";
    echo "<td>{$emp->ID}</td>";
    echo "<td>{$emp->post_title}</td>";
    echo "<td>{$linked_user} (" . ($user_map[$linked_user] ?? 'NOT FOUND') . ")</td>";
    echo "<td>{$emp->post_status}</td>";
    echo "</tr>";
}
echo "</table>";

// 3. Identify Orphans (Users with role 'hrm_employee' but no Employee Post)
echo "<h3>Potential Orphan Users</h3>";
echo "<ul>";
foreach ($users as $user) {
    if (in_array('hrm_employee', $user->roles) && !in_array($user->ID, $employee_user_ids)) {
        echo "<li style='color:red;'>User <strong>{$user->user_login}</strong> (ID: {$user->ID}) has 'hrm_employee' role but NO Employee Post linkage. This is likely blocking registration if you try to use this name again.</li>";
    }
}
echo "</ul>";
